/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_abs ( result, overflow, data ) ;

  parameter lpm_type = "lpm_abs" ;
  parameter lpm_width = 1 ;
  parameter polar_overflow = "NORMAL" ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_result   = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  output [lpm_width-1:0] result ;
  output overflow ;

  wire  [lpm_width-1:0] data ;
  reg   poverflow ;
  reg   [lpm_width-1:0] pdata ;
  reg   [lpm_width-1:0] tmp_result ;
  integer i, a_int;

  always @(data )
    begin
       pdata <= #1 (polar_data=="INVERT")?~data:data ;
    end
	
  always @(pdata)
    begin
	    poverflow = 0 ;
        // convert to negative integer
        if(pdata[lpm_width-1] == 1)
        begin
	    	a_int = 0 ;
            for(i = 0; i < lpm_width - 1; i = i + 1)
                a_int[i] = pdata[i] ^ 1;
            tmp_result = (a_int + 1) ;
	   		poverflow = (tmp_result == ( 1<<(lpm_width -1))) ;
        end
	    else tmp_result = pdata;
    end
	assign result = (polar_result=="INVERT")?~tmp_result:tmp_result ;
	assign overflow = (polar_overflow=="INVERT")?~poverflow:poverflow ;

endmodule // lpm_abs
`ifdef SYNTH
`else
`endcelldefine
`endif

